;;*****************************************************************************
;;*****************************************************************************
;;  FILENAME:   TRIADC_1.asm
;;  Version: 2.2, Updated on 2004/08/05 at 10:19:32
;;  Generated by PSoC Designer ver 4.2  b1013 : 02 September, 2004
;;
;;  DESCRIPTION: TriADC User Module software implementation file
;;               for the 25/26xxx PSoC family of devices.
;;
;;  NOTE: User Module APIs conform to the fastcall16 convention for marshalling
;;        arguments and observe the associated "Registers are volatile" policy.
;;        This means it is the caller's responsibility to preserve any values
;;        in the X and A registers that are still needed after the API functions
;;        returns. For Large Memory Model devices it is also the caller's 
;;        responsibility to perserve any value in the CUR_PP, IDX_PP, MVR_PP and 
;;        MVW_PP registers. Even though some of these registers may not be modified
;;        now, there is no guarantee that will remain the case in future releases.
;;-----------------------------------------------------------------------------
;;  Copyright (c) Cypress MicroSystems 2001-2003. All Rights Reserved.
;;*****************************************************************************
;;*****************************************************************************

include "TRIADC_1.inc"
include "m8c.inc"
include "memory.inc"

;-----------------------------------------------
;  Global Symbols
;-----------------------------------------------
export  TRIADC_1_Start
export _TRIADC_1_Start
export  TRIADC_1_SetPower
export _TRIADC_1_SetPower
export  TRIADC_1_Stop
export _TRIADC_1_Stop
export  TRIADC_1_GetSamples
export _TRIADC_1_GetSamples
export  TRIADC_1_StopAD
export _TRIADC_1_StopAD
export  TRIADC_1_fIsData
export _TRIADC_1_fIsData
export  TRIADC_1_fIsDataAvailable
export _TRIADC_1_fIsDataAvailable
export  TRIADC_1_iGetData1
export _TRIADC_1_iGetData1
export  TRIADC_1_iGetData2
export _TRIADC_1_iGetData2
export  TRIADC_1_iGetData3
export _TRIADC_1_iGetData3
export  TRIADC_1_ClearFlag
export _TRIADC_1_ClearFlag
export  TRIADC_1_iGetData1ClearFlag
export _TRIADC_1_iGetData1ClearFlag
export  TRIADC_1_iGetData2ClearFlag
export _TRIADC_1_iGetData2ClearFlag
export  TRIADC_1_iGetData3ClearFlag
export _TRIADC_1_iGetData3ClearFlag
export  TRIADC_1_SetResolution
export _TRIADC_1_SetResolution

;-----------------------------------------------
;  EQUATES
;-----------------------------------------------
; Calctime parameters
wCalcTime:     equ   TRIADC_1_bCALCTIME

; Constants
LowByte:       equ 1
HighByte:      equ 0

AREA UserModules (ROM, REL)
.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME: TRIADC_1_Start
;  FUNCTION NAME: TRIADC_1_SetPower
;
;  DESCRIPTION:
;     Applies power setting to the module's analog PSoc block.
;
;-----------------------------------------------------------------------------
;
;  ARGUMENTS:
;    A contains the power setting (0 - 3)
;
;  RETURNS: none
;
;  SIDE EFFECTS:
;    The A and X registers may be modified by this or future implementations
;    of this function.  The same is true for all RAM page pointer registers in
;    the Large Memory Model.  When necessary, it is the calling function's
;    responsibility to perserve their values across calls to fastcall16 
;    functions.
;          
;    Currently only the page pointer registers listed below are modified: 
;          CUR_PP
;
 TRIADC_1_Start:
_TRIADC_1_Start:
 TRIADC_1_SetPower:
_TRIADC_1_SetPower:
   RAM_PROLOGUE RAM_USE_CLASS_4
   RAM_PROLOGUE RAM_USE_CLASS_2
   RAM_SETPAGE_CUR >TRIADC_1_bfStatus
   and   A,TRIADC_1_bfPOWERMASK                      ; Mask only the valid power setting bits
   mov   X, SP                                       ; Get location of next location on stack
   push  A                                           ; Save power value on temp location

                                                     ; Set power for ADC1
   mov   A, reg[TRIADC_1_bfADC1cr3]                  ; Get current value of ADC1cr3
   and   A, ~TRIADC_1_bfPOWERMASK                    ; Mask off old power value
   or    A, [X]                                      ; OR in new power value
   or    A, f0h                                      ; Make sure other register is set correctly
   mov   reg[TRIADC_1_bfADC1cr3], A                  ; Reload CR with new power value

                                                     ; Set power for ADC2
   mov   A, reg[TRIADC_1_bfADC2cr3]                  ; Get current value of ADC2cr3
   and   A, ~TRIADC_1_bfPOWERMASK                    ; Mask off old power value
   or    A, [X]                                      ; OR in new power value
   or    A, f0h                                      ; Make sure other register is set correctly
   mov   reg[TRIADC_1_bfADC2cr3], A                  ; Reload CR with new power value

                                                     ; Set power for ADC3
   mov   A, reg[TRIADC_1_bfADC3cr3]                  ; Get current value of ADC3cr3
   and   A, ~TRIADC_1_bfPOWERMASK                    ; Mask off old power value
   or    A, [X]                                      ; OR in new power value
   or    A, f0h                                      ; Make sure other register is set correctly
   mov   reg[TRIADC_1_bfADC3cr3], A                  ; Reload CR with new power value

   tst   reg[TRIADC_1_bfADC1cr2], TRIADC_1_fRES_SET
   jz    .DoNotLoadRes
   mov   A,TRIADC_1_bNUMBITS - TRIADC_1_bMINRES                 ; get and set the resolution
   mov   [TRIADC_1_bfStatus], A              ; place it in the status variable
.DoNotLoadRes:

   pop   A                                           ; Restore the stack and power value
   RAM_EPILOGUE RAM_USE_CLASS_2
   RAM_EPILOGUE RAM_USE_CLASS_4
   ret
.ENDSECTION

.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME: TRIADC_1_Stop
;
;  DESCRIPTION:
;    Removes power from the module's analog PSoc block, but the digital
;    blocks keep on running.
;
;-----------------------------------------------------------------------------
;
;  ARGUMENTS:  none
;
;  RETURNS:  none
;
;  SIDE EFFECTS:
;    The A and X registers may be modified by this or future implementations
;    of this function.  The same is true for all RAM page pointer registers in
;    the Large Memory Model.  When necessary, it is the calling function's
;    responsibility to perserve their values across calls to fastcall16 
;    functions.
;
 TRIADC_1_Stop:
_TRIADC_1_Stop:
   RAM_PROLOGUE RAM_USE_CLASS_1
   and   reg[TRIADC_1_bfADC1cr3], ~TRIADC_1_bfPOWERMASK
   and   reg[TRIADC_1_bfADC2cr3], ~TRIADC_1_bfPOWERMASK
   and   reg[TRIADC_1_bfADC3cr3], ~TRIADC_1_bfPOWERMASK
   RAM_EPILOGUE RAM_USE_CLASS_1
   ret
.ENDSECTION

.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME: TRIADC_1_Get_Samples
;
;  DESCRIPTION:
;    Starts the A/D convertor and will place data is memory.  A flag
;    is set whenever a new data value is available.
;
;-----------------------------------------------------------------------------
;
;  ARGUMENTS:
;    A Contains the number of samples to perform. (0 is continous)
;
;  RETURNS: none
;
;  SIDE EFFECTS:
;    The A and X registers may be modified by this or future implementations
;    of this function.  The same is true for all RAM page pointer registers in
;    the Large Memory Model.  When necessary, it is the calling function's
;    responsibility to perserve their values across calls to fastcall16 
;    functions.
;          
;    Currently only the page pointer registers listed below are modified: 
;          CUR_PP
;
 TRIADC_1_GetSamples:
_TRIADC_1_GetSamples:
   RAM_PROLOGUE RAM_USE_CLASS_4
   RAM_SETPAGE_CUR >TRIADC_1_bSampC
   mov   [TRIADC_1_bSampC], A                              ; Store sample count

   mov   A,[TRIADC_1_bfStatus]                             ; get and set the resolution
   and   A,TRIADC_1_bRES_MASK
   add   A,TRIADC_1_bMINRES
   call  TRIADC_1_SetResolution

TRIADC_1_LoadMSBCounter:                                   ; The PWM has been setup by SetResolution, now set the upper
                                                           ; counter which will be the same as the period.
                                                           ; Reset MSB of counter to most negative value
   RAM_SETPAGE_CUR >TRIADC_1_cCounter1U
   mov   A,reg[TRIADC_1_bPWM_IntTime_MSB]                  ; Get MSB of PWM and move it into RAM
   mov   [TRIADC_1_cCounter1U], A                          ; Use counter as temp location
   mov   A, 00h                                            ; Load A with zero for the calculation
   sub   A, [TRIADC_1_cCounter1U]                          ; 0 - MSB_PWM = MSB_of_most_neg_value
   asr   A                                                 ; Half the range (+ and -)
IF (TRIADC_1_DATA_FORMAT)
   mov   [TRIADC_1_cCounter1U], A                          ; Place result back into MSB of counter1
   mov   [TRIADC_1_cCounter2U], A                          ; Place result back into MSB of counter2
   mov   [TRIADC_1_cCounter3U], A                          ; Place result back into MSB of counter3
ELSE
   mov   [TRIADC_1_cCounter1U], 00h                        ; Always start at zero for unsigned values for ADC1
   mov   [TRIADC_1_cCounter2U], 00h                        ; Always start at zero for unsigned values for ADC2
   mov   [TRIADC_1_cCounter3U], 00h                        ; Always start at zero for unsigned values for ADC3
ENDIF
   mov   A, reg[TRIADC_1_bPWM_IntTime_LSB]                 ; Dummy Read  - required do not remove
   mov   reg[TRIADC_1_bPeriod1], FFh                       ; Make sure counter1 starts at FF
   mov   reg[TRIADC_1_bPeriod2], FFh                       ; Make sure counter1 starts at FF
   mov   reg[TRIADC_1_bPeriod3], FFh                       ; Make sure counter1 starts at FF

   and   reg[TRIADC_1_bfADC1cr3],~TRIADC_1_fFSW0           ; Take Integrator out of reset
   and   reg[TRIADC_1_bfADC2cr3],~TRIADC_1_fFSW0           ; Take Integrator out of reset
   and   reg[TRIADC_1_bfADC3cr3],~TRIADC_1_fFSW0           ; Take Integrator out of reset
IF TRIADC_1_NoAZ
    and  reg[TRIADC_1_bfADC1cr2],~TRIADC_1_fAutoZero       ; Take Integrator out of AutoZero
    and  reg[TRIADC_1_bfADC2cr2],~TRIADC_1_fAutoZero       ; Take Integrator out of AutoZero
    and  reg[TRIADC_1_bfADC3cr2],~TRIADC_1_fAutoZero       ; Take Integrator out of AutoZero
ENDIF

                                                               ; Enable the A/D and Start it!
   or    reg[TRIADC_1_bCounter1_CR0], (TRIADC_1_fDBLK_ENABLE|TRIADC_1_fPULSE_WIDE)   ; Enable the Counter
   or    reg[TRIADC_1_bCounter2_CR0], (TRIADC_1_fDBLK_ENABLE|TRIADC_1_fPULSE_WIDE)   ; Enable the Counter
   or    reg[TRIADC_1_bCounter3_CR0], (TRIADC_1_fDBLK_ENABLE|TRIADC_1_fPULSE_WIDE)   ; Enable the Counter
   or    reg[TRIADC_1_fPWM_LSB_CR0], TRIADC_1_fDBLK_ENABLE          ; Enable PWM
   or    reg[TRIADC_1_bfPWM16_INT_REG], TRIADC_1_bfPWM16_Mask  ; Enable PWM and Counter interrupts
   or    reg[TRIADC_1_bfCounter1_INT_REG], TRIADC_1_bfCounter1_Mask
   or    reg[TRIADC_1_bfCounter2_INT_REG], TRIADC_1_bfCounter2_Mask
   or    reg[TRIADC_1_bfCounter3_INT_REG], TRIADC_1_bfCounter3_Mask
   RAM_EPILOGUE RAM_USE_CLASS_4
   ret
.ENDSECTION

.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME: TRIADC_1_StopAD
;
;  DESCRIPTION:
;    Completely shuts down the A/D is an orderly manner.  Both the
;    Timer and Counter are disabled and their interrupts are deactivated.
;
;-----------------------------------------------------------------------------
;
;  ARGUMENTS: none
;
;  RETURNS: none
;
;  SIDE EFFECTS:
;    The A and X registers may be modified by this or future implementations
;    of this function.  The same is true for all RAM page pointer registers in
;    the Large Memory Model.  When necessary, it is the calling function's
;    responsibility to perserve their values across calls to fastcall16 
;    functions.
;
 TRIADC_1_StopAD:
_TRIADC_1_StopAD:
   RAM_PROLOGUE RAM_USE_CLASS_1
   and   reg[TRIADC_1_fPWM_LSB_CR0], ~TRIADC_1_fDBLK_ENABLE    ; Disable the PWM

   and   reg[TRIADC_1_bCounter1_CR0], ~TRIADC_1_fDBLK_ENABLE           ; Disable the Counter
   and   reg[TRIADC_1_bCounter2_CR0], ~TRIADC_1_fDBLK_ENABLE           ; Disable the Counter
   and   reg[TRIADC_1_bCounter3_CR0], ~TRIADC_1_fDBLK_ENABLE           ; Disable the Counter

IF TRIADC_1_NoAZ
   or    reg[TRIADC_1_bfADC1cr2], TRIADC_1_fAutoZero           ; Put the Integrator into Autozero mode
   or    reg[TRIADC_1_bfADC2cr2], TRIADC_1_fAutoZero           ; Put the Integrator into Autozero mode
   or    reg[TRIADC_1_bfADC3cr2], TRIADC_1_fAutoZero           ; Put the Integrator into Autozero mode
ENDIF

   or   reg[TRIADC_1_bfADC1cr3], TRIADC_1_fFSW0                ; Put Integrator into reset
   or   reg[TRIADC_1_bfADC2cr3], TRIADC_1_fFSW0                ; Put Integrator into reset
   or   reg[TRIADC_1_bfADC3cr3], TRIADC_1_fFSW0                ; Put Integrator into reset

   push A
   M8C_DisableIntMask TRIADC_1_bfPWM16_INT_REG, TRIADC_1_bfPWM16_Mask      ; Disable interrupts
   M8C_DisableIntMask TRIADC_1_bfCounter1_INT_REG, TRIADC_1_bfCounter1_Mask
   M8C_DisableIntMask TRIADC_1_bfCounter2_INT_REG, TRIADC_1_bfCounter2_Mask
   M8C_DisableIntMask TRIADC_1_bfCounter3_INT_REG, TRIADC_1_bfCounter3_Mask
   pop  A
   RAM_EPILOGUE RAM_USE_CLASS_1
   ret
.ENDSECTION

.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME: TRIADC_1_fIsData
;  FUNCTION NAME: TRIADC_1_fIsDataAvailable
;
;  DESCRIPTION:
;    Returns the status of the A/D Data is set whenever a new data value
;    is available.
;
;-----------------------------------------------------------------------------
;
;  ARGUMENTS: none
;
;  RETURNS: A returns data status in A.  A != 0  Data available
;                                        A  = 0  Data not available
;
;  SIDE EFFECTS:
;    The A and X registers may be modified by this or future implementations
;    of this function.  The same is true for all RAM page pointer registers in
;    the Large Memory Model.  When necessary, it is the calling function's
;    responsibility to perserve their values across calls to fastcall16 
;    functions.
;          
;    Currently only the page pointer registers listed below are modified: 
;          CUR_PP
;
 TRIADC_1_fIsData:
_TRIADC_1_fIsData:
 TRIADC_1_fIsDataAvailable:
_TRIADC_1_fIsDataAvailable:
   RAM_PROLOGUE RAM_USE_CLASS_4
   RAM_SETPAGE_CUR >TRIADC_1_bfStatus
   mov   A, [TRIADC_1_bfStatus]                       ; Get status byte
   and   A, TRIADC_1_fDATA_READY                      ; Mask off other bits
   RAM_EPILOGUE RAM_USE_CLASS_4
   ret
.ENDSECTION

.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME: TRIADC_1_iGetData1
;  FUNCTION NAME: TRIADC_1_iGetData1ClearFlag
;
;  DESCRIPTION:
;    Returns the data from the A/D.  Does not check if data is available.
;
;-----------------------------------------------------------------------------
;
;  ARGUMENTS: none
;
;  RETURNS:
;     X:A contains 16 bit ADC result.  X = MSB, A = LSB
;
;  SIDE EFFECTS:
;    The A and X registers may be modified by this or future implementations
;    of this function.  The same is true for all RAM page pointer registers in
;    the Large Memory Model.  When necessary, it is the calling function's
;    responsibility to perserve their values across calls to fastcall16 
;    functions.
;          
;    Currently only the page pointer registers listed below are modified: 
;          CUR_PP
;
 TRIADC_1_iGetData1ClearFlag:
_TRIADC_1_iGetData1ClearFlag:
   RAM_PROLOGUE RAM_USE_CLASS_4
   RAM_SETPAGE_CUR >TRIADC_1_bfStatus
   and   [TRIADC_1_bfStatus], ~TRIADC_1_fDATA_READY  ; Clear Data ready bit
   mov   X, [(TRIADC_1_iResult1 + HighByte)]
   mov   A, [(TRIADC_1_iResult1 + LowByte)]
   RAM_EPILOGUE RAM_USE_CLASS_4
   ret

 TRIADC_1_iGetData1:
_TRIADC_1_iGetData1:
   RAM_PROLOGUE RAM_USE_CLASS_4
   RAM_SETPAGE_CUR >TRIADC_1_bfStatus
   mov   X, [(TRIADC_1_iResult1 + HighByte)]
   mov   A, [(TRIADC_1_iResult1 + LowByte)]
   RAM_EPILOGUE RAM_USE_CLASS_4
   ret
.ENDSECTION

.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME: TRIADC_1_iGetData2
;  FUNCTION NAME: TRIADC_1_iGetData2ClearFlag
;
;  DESCRIPTION:
;    Returns the data from the A/D.  Does not check if data is available.
;
;-----------------------------------------------------------------------------
;
;  ARGUMENTS: none
;
;  RETURNS:
;     X:A contains 16 bit ADC result.  X = MSB, A = LSB
;
;  SIDE EFFECTS:
;    The A and X registers may be modified by this or future implementations
;    of this function.  The same is true for all RAM page pointer registers in
;    the Large Memory Model.  When necessary, it is the calling function's
;    responsibility to perserve their values across calls to fastcall16 
;    functions.
;          
;    Currently only the page pointer registers listed below are modified: 
;          CUR_PP
;
 TRIADC_1_iGetData2ClearFlag:
_TRIADC_1_iGetData2ClearFlag:
   RAM_PROLOGUE RAM_USE_CLASS_4
   RAM_SETPAGE_CUR >TRIADC_1_bfStatus
   and   [TRIADC_1_bfStatus], ~TRIADC_1_fDATA_READY  ; Clear Data ready bit
   mov   X, [(TRIADC_1_iResult2 + HighByte)]
   mov   A, [(TRIADC_1_iResult2 + LowByte)]
   RAM_EPILOGUE RAM_USE_CLASS_4
   ret

 TRIADC_1_iGetData2:
_TRIADC_1_iGetData2:
   RAM_PROLOGUE RAM_USE_CLASS_4
   RAM_SETPAGE_CUR >TRIADC_1_bfStatus
   mov   X, [(TRIADC_1_iResult2 + HighByte)]
   mov   A, [(TRIADC_1_iResult2 + LowByte)]
   RAM_EPILOGUE RAM_USE_CLASS_4
   ret
.ENDSECTION

.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME: TRIADC_1_iGetData3
;  FUNCTION NAME: TRIADC_1_iGetData3ClearFlag
;
;  DESCRIPTION:
;    Returns the data from the A/D.  Does not check if data is available.
;
;-----------------------------------------------------------------------------
;
;  ARGUMENTS:
;
;  RETURNS:
;     X:A contains 16 bit ADC result.  X = MSB, A = LSB
;
;  SIDE EFFECTS:
;    The A and X registers may be modified by this or future implementations
;    of this function.  The same is true for all RAM page pointer registers in
;    the Large Memory Model.  When necessary, it is the calling function's
;    responsibility to perserve their values across calls to fastcall16 
;    functions.
;          
;    Currently only the page pointer registers listed below are modified: 
;          CUR_PP
;
 TRIADC_1_iGetData3ClearFlag:
_TRIADC_1_iGetData3ClearFlag:
   RAM_PROLOGUE RAM_USE_CLASS_4
   RAM_SETPAGE_CUR >TRIADC_1_bfStatus
   and   [TRIADC_1_bfStatus], ~TRIADC_1_fDATA_READY  ; Clear Data ready bit
   mov   X, [(TRIADC_1_iResult3 + HighByte)]
   mov   A, [(TRIADC_1_iResult3 + LowByte)]
   RAM_EPILOGUE RAM_USE_CLASS_4
   ret

 TRIADC_1_iGetData3:
_TRIADC_1_iGetData3:
   RAM_PROLOGUE RAM_USE_CLASS_4
   RAM_SETPAGE_CUR >TRIADC_1_bfStatus
   mov   X, [(TRIADC_1_iResult3 + HighByte)]
   mov   A, [(TRIADC_1_iResult3 + LowByte)]
   RAM_EPILOGUE RAM_USE_CLASS_4
   ret
.ENDSECTION

.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME: TRIADC_1_ClearFlag
;
;  DESCRIPTION:
;    Clears the data ready flag.
;
;-----------------------------------------------------------------------------
;
;  ARGUMENTS: none
;
;  RETURNS: none
;
;  SIDE EFFECTS:
;    The A and X registers may be modified by this or future implementations
;    of this function.  The same is true for all RAM page pointer registers in
;    the Large Memory Model.  When necessary, it is the calling function's
;    responsibility to perserve their values across calls to fastcall16 
;    functions.
;          
;    Currently only the page pointer registers listed below are modified: 
;          CUR_PP
;
 TRIADC_1_ClearFlag:
_TRIADC_1_ClearFlag:
   RAM_PROLOGUE RAM_USE_CLASS_4
   RAM_SETPAGE_CUR >TRIADC_1_bfStatus
   and   [TRIADC_1_bfStatus], ~TRIADC_1_fDATA_READY  ; Clear Data ready bit
   RAM_EPILOGUE RAM_USE_CLASS_4
   ret
.ENDSECTION

.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME: TRIADC_1_SetResolution
;
;  DESCRIPTION:
;    Sets A/D resolution between 7 and 13 bits.
;
;-----------------------------------------------------------------------------
;
;  ARGUMENTS:
;   A => passes the number of bits of resolution. ( 7 to 13)
;
;  RETURNS:
;
;  SIDE EFFECTS:
;    The A and X registers may be modified by this or future implementations
;    of this function.  The same is true for all RAM page pointer registers in
;    the Large Memory Model.  When necessary, it is the calling function's
;    responsibility to perserve their values across calls to fastcall16 
;    functions.
;          
;    Currently only the page pointer registers listed below are modified: 
;          CUR_PP
;
;    This function halts the PWM and the counter to sync the A/D , but
;    does not re-enable the counter or PWM. To restart the A/D, "Get_Samples"
;    should be called.
;
 TRIADC_1_SetResolution:
_TRIADC_1_SetResolution:
   RAM_PROLOGUE RAM_USE_CLASS_4
   RAM_SETPAGE_CUR >TRIADC_1_bfStatus
   
   and   reg[TRIADC_1_bfADC1cr2], ~TRIADC_1_fRES_SET

   call  TRIADC_1_StopAD                           ; Stop the A/D if it is running
   mov   [TRIADC_1_bfStatus], 00h                  ; and clear status and old resolution

                                                   ; Check for resolution to be within min and max values
   cmp   A,TRIADC_1_bMINRES                        ; Check low end of resolution
   jnc   TRIADC_1_CHECKHI
   mov   A,TRIADC_1_bMINRES                        ; Too low - load legal low value
   jmp   TRIADC_1_RES_OK

TRIADC_1_CHECKHI:                                  ; Check high end of resolution
   cmp   A,TRIADC_1_bMAXRES
   jc    TRIADC_1_RES_OK
   mov   A,TRIADC_1_bMAXRES                        ; Too high - load legal Max value

TRIADC_1_RES_OK:
                                                   ; Calculate compare value for the PWM which
                                                   ; computes the integrate time
   sub   A, TRIADC_1_bMINRES                       ; Normalize with min resolution
   or    [TRIADC_1_bfStatus], A
                                                   ; Since min resolution is 7, 2^^7 = 128, the clock
                                                   ; is running 4x so 128*4=512 or 0x0200
   add   A,01h                                     ; The MSB is 02h.
   mov   X,A
   mov   A,01h

TRIADC_1_CALC_INTTIME:                             ; Now shift the MSB left for every bit of resolution of min (7).
   asl   A
   dec   X
   jnz   TRIADC_1_CALC_INTTIME

TRIADC_1_LOAD_INTTIME:                             ; Load compare value and Calc time into registers
                                                   ; Since minimum resolution is 7 bits, this value will always start at 0
   mov   reg[TRIADC_1_bPWM_IntTime_LSB], 00h
   mov   reg[TRIADC_1_bPWM_IntTime_MSB], A

                                                   ; Load the CalcTime into the PWM Period
   mov   reg[TRIADC_1_bPWM_Period_LSB], <wCalcTime
   add   A, >wCalcTime
   mov   reg[TRIADC_1_bPWM_Period_MSB],A
   RAM_EPILOGUE RAM_USE_CLASS_4
   ret
.ENDSECTION

; End of File TRIADC_1.asm
